import java.io.*;
import java.util.*;

public class Decrypter{
/**
 * Helps decode an encrypted file.
 * Notes/Assumptions: Only letters and spaces are in the input file.  Lowercase and Uppercase letters are ignored.
 * Also, "_" represents a whitespace in the original unencrypted file
 * */
	
	public static void main (String[] args) throws IOException {

		replaceCharsinFile("sample.txt", "hidden.txt", 1);		//change the last argument to specify 1, 2, 3... length string replacement.
		
	} //end main

	
	//This function replaces most common, second most common, etc... character from file 2 with the most common, second most common, etc... character
	//from file 1. The length parameter is for specifying whether it's one character, 2 character, 3 character, etc.. replacement.
	public static void replaceCharsinFile(String file1, String file2, int length) throws IOException{
		
		//set up the file reader to read the hidden/encrypted text.
		FileReader hiddentext = new FileReader(file2);
		BufferedReader hiddenIn = new BufferedReader(hiddentext);
		
		//output changes to unencrypted.txt
		FileOutputStream output = new FileOutputStream("unencrypted.txt");
		PrintWriter goingOut = new PrintWriter(output);
		
		String[] mostcommonfile1; //the most common character(s) will be held in this array for file 1
		String[] mostcommonfile2; //the most common character(s) will be held in this array for file 2

		
		//read in the entire file and put it into one string.
		String filestring = "", temp1;
		while((temp1 = hiddenIn.readLine()) != null){
			filestring += temp1;
		}
		
		//replace orignal spaces with underlines to distinguish from new spaces put in
		filestring = filestring.replaceAll("\\W", "_");
		System.out.println("BEFORE: " + filestring);

			for(int i = 1; i < 20; i++){
				mostcommonfile1 = mostCommoninFile(file1, i, length);
				mostcommonfile2 = mostCommoninFile(file2, i, length);
				
//				for(int j = 0; j<mostcommonfile2.length;j++){
//					System.out.print(mostcommonfile2[j] + ", ");
//				}

				if(!mostcommonfile2[0].equals("*")  && !mostcommonfile1[0].equals("*")){
					if(!mostcommonfile2[1].equals("*")){
						int k = 0;
						while(!mostcommonfile2[k].equals("*")){
							mostcommonfile1 = mostCommoninFile(file1, i+k, length);
							System.out.println("Replacing " + mostcommonfile2[k] + " with " + mostcommonfile1[0]);
							filestring = filestring.replace(mostcommonfile2[k], (mostcommonfile1[0].toUpperCase()));
							k++;
						}
					}
						System.out.println("Replacing " + mostcommonfile2[0] + " with " + mostcommonfile1[0]);
						filestring = filestring.replace(mostcommonfile2[0], (mostcommonfile1[0].toUpperCase()));
				}
			}
			
	
		System.out.println("AFTER: " + filestring);
		goingOut.println(filestring);

		hiddenIn.close();
		goingOut.close();

		
	}
	
public static String[] mostCommoninFile(String file1, int rank, int length) throws IOException{
		
		FileReader hiddentext = new FileReader(file1);
		BufferedReader hiddenIn = new BufferedReader(hiddentext);

		
		HashMap<String, Integer> m = new HashMap<String, Integer>();
		String[] commonarr = new String[2000];
		
		String filestringhidden = "", temp1;

		//Get the hidden file string
		while((temp1 = hiddenIn.readLine()) != null){
			filestringhidden += temp1;
		}
		
		if(file1.equals("hidden.txt")){
			filestringhidden = filestringhidden.replaceAll("\\W", "_");
		}
		
		int count = 0;
		while((count+length) < filestringhidden.length() ){
			String pair = filestringhidden.substring(count, count+length);
			if(!(m.containsKey(pair))){
				m.put(pair, 1);
			}
			else{
				int  j = m.get(pair) + 1;
				m.put(pair, j);
			}
			count++;
		}
		
		Set<String> keys = m.keySet();

		for(int i = 0; i < rank; i++){
			
			int max = 0;
			for(String pair:keys){
				if(max < m.get(pair)){
					max = m.get(pair);
				}
			}
			
			int counter = 0;
			//System.out.println("Max = " + max);
			for(String pair:keys ){
				if(max == m.get(pair) && max != 0){
					
					commonarr[counter] = pair;
					counter++;
					m.put(pair, new Integer(0));
					
				}
			}
			
			for(int k = counter; k < commonarr.length; k++){
				commonarr[k] = "*";
			}
		}
		
		hiddenIn.close();
		return commonarr;
		

	}
		
	//prints and integer array
	public static void printIntArr(int[] arr){
		for(int i = 0; i < arr.length; i++)
			System.out.print(arr[i]);
	}
	

} // end entire class
